﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MarqueeList.aspx.cs" Inherits="DimoNetwork.ProxyWeb.SysRoot.MarqueeList" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="css/style.css" rel="stylesheet" type="text/css" />
    <link href="css/select.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="js/jquery.js"></script>
    <script type="text/javascript" src="js/jquery.idTabs.min.js"></script>
    <script src="js/DatePicker/WdatePicker.js"></script>
    <script src="/js/Common.js"></script>
    <script>
        $(document).ready(function (e) {
            SetOrderByField($("#<%=hdOrderByField.ClientID%>").val(), $("#<%=hdOrderByType.ClientID%>").val());
        });

        function OrderByClick(filed, orderByType) {
            var parameters = "&BeginTime=" + $("#<%=txtBeginTime.ClientID %>").val() + "&EndTime=" + $("#<%=txtEndTime.ClientID %>").val();
            OrderBy(filed, orderByType, parameters);
          }
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="place">
            <span>位置：</span>
            <ul class="placeul">
                <li><a href="/SysRoot/index.aspx">首页</a></li>
                <li><a href="#">发广告</a></li>
            </ul>
        </div>

        <div class="rightinfo">
            <div class="itab">
                <ul id="tabUl">
                    <li><a href="#tab1" onclick="location.href='/SysRoot/MarqueeManager.aspx#tab1'">发广告</a></li>
                    <li><a href="#tab2">发送记录</a></li>
                </ul>
            </div>
            <div class="tabson">
                <ul class="seachform">

                    <li>
                        <label>日期</label>
                        <input name="" id="txtBeginTime" runat="server" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',maxDate:'#F{$dp.$D(\'txtEndTime\',{d:0});}'})" type="text" class="scinput" />-
                        <input name="" id="txtEndTime" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'#F{$dp.$D(\'txtBeginTime\',{d:0});}'})" runat="server" type="text" class="scinput" />
                    </li>

                    <li>
                        <label>&nbsp;</label><asp:Button ID="btnQuery" class="scbtn" runat="server" Text="查询" OnClick="btnQuery_Click" />
                    </li>

                </ul>

                <input type="hidden" id="hdOrderByType" runat="server" value="" />
                <input type="hidden" id="hdOrderByField" runat="server" value="" />
                <table class="tablelist">
                    <thead>
                        <tr>
                            <th>序号</th>
                            <th>发送内容</th>
                            <th>发送次数</th>
                            <th><a href='javascript:OrderByClick("Price","");' id="OrderByA_Price" class="tablelink">价格</a></th>
                            <th>操作IP</th>
                            <th><a href='javascript:OrderByClick("CreateTime","");' id="OrderByA_CreateTime" class="tablelink">发送时间</a></th>
                        </tr>
                    </thead>
                    <tbody>
                        <asp:Repeater ID="reptDataPager" runat="server">
                            <ItemTemplate>
                                <tr>
                                    <td><%# Eval("RowIndex") %></td>
                                    <td><%#Eval("Content") %></td>
                                    <td><%#Eval("SendCounts") %></td>
                                    <td><%#FormatMoney(Eval("Price")) %></td>
                                    <td><%# Eval("Ip") %></td>
                                    <td><%#Eval("CreateTime") %></td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </tbody>
                </table>

            </div>
            <div class="pagination pull-right">
                <webdiyer:AspNetPager ID="anpDataPager" runat="server" CustomInfoHTML="共%PageCount%页，当前为第%CurrentPageIndex%页，每页%PageSize%条" FirstPageText="|<" LastPageText=">|" NextPageText=">" PageSize="10" PrevPageText="<" ShowCustomInfoSection="Left" CssClass="pagination" LayoutType="Ul" PagingButtonLayoutType="UnorderedList" PagingButtonSpacing="0" CurrentPageButtonClass="active" OnPageChanged="anpDataPager_PageChanged"></webdiyer:AspNetPager>
            </div>
        </div>

        <script type="text/javascript">
            $("#tabUl").idTabs("tab2");
            $('.tablelist tbody tr:odd').addClass('odd');
        </script>
    </form>
</body>
</html>

